package com.bxm.adx.common.adapter;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;

/**
 * 买方模型适配器
 *
 * @author allen
 * @since 2019-12-12
 */
public interface BuyModelAdapter extends ModelAdapter {

    /**
     * 将卖方请求转换成买方请求
     * @param request 卖方请求
     * @return 买方请求
     */
    byte[] buildRequest(BidRequest request);

    /**
     * <p>将买方响应转换成卖方响应</p>
     *
     * <p>注意：如果买方没有广告填充，请将 {@code BidResponse} 返回设置为 {@code null}</p>
     *
     * @param response 卖方响应
     * @return 买方响应
     */
    BidResponse buildResponse(byte[] response);
}
