package com.bxm.adx.common.adapter;

import com.bxm.adx.common.AdxConstants;

/**
 * 模型适配器
 *
 * @author allen
 * @since 2019-12-12
 */
public interface ModelAdapter {

    default AdxConstants.Format getRequestFormat() {
        return AdxConstants.Format.Json;
    }

    /**
     * 转换request格式为可读
     *
     * @param request
     * @return 可读字符串
     */
    default String convertRequest(byte[] request) {
        return request == null ? null : new String(request);
    }

    /**
     * 转换response格式为可读
     *
     * @param response
     * @return 可读字符串
     */
    default String convertResponse(byte[] response) {
        return response == null ? null : new String(response);
    }
}
