package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.DispatcherFlowProperties;
import com.bxm.adx.common.buy.dispatcher.DefaultDispatcherFlowControl;
import com.bxm.adx.common.buy.dispatcher.DispatcherFlowControl;
import com.bxm.adx.common.buy.dispatcher.filter.FlowControlFilter;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import com.bxm.warcar.xcache.fetchers.RedisFetcher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

/**
 * @author fgf
 * @date 2023/5/4
 **/
@ConditionalOnProperty(prefix = "adx", value = "enable-dispatcher-control", havingValue = "true")
@EnableConfigurationProperties({DispatcherFlowProperties.class})
public class DispatcherFlowControlAutoConfiguration {

    private final DispatcherFlowProperties properties;

    public DispatcherFlowControlAutoConfiguration(DispatcherFlowProperties properties) {
        this.properties = properties;
    }

    @Bean
    public LoadingCacheFetcher dispatcherFlowFetcher(RedisFetcher redisFetcher) {
        return new LoadingCacheFetcher(redisFetcher, properties.getCacheTime(), properties.getTimeUnit());
    }

    @Bean
    @ConditionalOnMissingBean(DispatcherFlowControl.class)
    public DefaultDispatcherFlowControl dispatcherFlowControl(JedisPool jedisPool, @Qualifier("dispatcherFlowFetcher") Fetcher fetcher) {
        return new DefaultDispatcherFlowControl(properties, jedisPool, fetcher);
    }

    @Bean
    public FlowControlFilter flowControlFilter(DispatcherFlowControl dispatcherFlowControl, Pair pair) {
        return new FlowControlFilter(dispatcherFlowControl, pair);
    }
}
