package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.utils.ServerUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * @author fgf
 * @date 2024/9/6
 **/
public class OnMultipleConditions implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        // 例如，多个条件，其中之一是检查IP是否在特定范围
        boolean condition1 = checkSpecificIp();
        boolean condition2 = checkEnvironmentVariable(context);

        // 如果任意一个条件满足，返回true
        return condition1 || condition2;
    }

    // 条件1: 检查IP是否在特定内网IP列表中
    private boolean checkSpecificIp() {
        String localIp = ServerUtils.getLocalIpAddress();
        return GlobalServerConfig.IP_LIST.contains(localIp);
    }

    // 条件2: 检查某个环境变量是否设置
    private boolean checkEnvironmentVariable(ConditionContext context) {
        // 获取 Spring 环境对象
        Environment env = context.getEnvironment();

        // 从配置文件中读取参数值
        String myProperty = env.getProperty("adx.enable-model-adapter-proxy-factory");

        // 根据配置文件的参数值决定是否创建 Bean
        return "true".equalsIgnoreCase(myProperty);
    }
}