package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.facade.constant.pushable.CachePushableFields;
import com.bxm.mccms.facade.model.pushable.DispatcherAbCacheVO;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Objects;

@CachePush("DISPATCHERAB")
@Component
@Slf4j
public class DispatcherAB implements Pushable {
    private final Updater updater;
    private final DataSyncProducer dataSyncProducer;

    public DispatcherAB(Updater updater, DataSyncProducer dataSyncProducer) {
        this.updater = updater;
        this.dataSyncProducer = dataSyncProducer;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get(CachePushableFields.POSITION_ID);
        //参数验证
        if (Objects.isNull(o)) {
            if (log.isInfoEnabled()) {
                log.info("DISPATCHERAB push err: POSITION_ID is null");
            }
            return;
        }
        String positionId = Objects.toString(o);

        if (log.isInfoEnabled()) {
            log.info("DISPATCHERAB push {} : {}", positionId, new String(data));
        }
        DispatcherAbCacheVO dispatcherAbCacheVO = JsonHelper.convert(data, DispatcherAbCacheVO.class);
        if (dispatcherAbCacheVO == null) {
            return;
        }

        String key = dispatcherAbCacheVO.getClass().getName() + "$" + dispatcherAbCacheVO.getPositionId();
        dataSyncProducer.post(key, dispatcherAbCacheVO);

        //移除广告位下用户重排序
        // FIXME: 2023/2/8 这个key有数据过大风险，造成redis异常
        updater.remove(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId));
    }
}
