package com.bxm.adx.common.buy.dsp;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;

/**
 * For cache pushable
 *
 * <pre>
 *     name = "DSP"
 *     parameters = {}
 *     byte[] = Dsp object to json bytes
 * </pre>
 *
 * @author allen
 * @since 2019-12-18
 */
@CachePush("DSP")
@Component
@Slf4j
public class DspDaoImpl implements DspDao, Pushable {

    private final Updater updater;
    private final DataSyncProducer dataSyncProducer;
    private final DspCached dspCached;

    public DspDaoImpl(Updater updater, DataSyncProducer dataSyncProducer, DspCached dspCached) {
        this.updater = updater;
        this.dataSyncProducer = dataSyncProducer;
        this.dspCached = dspCached;
    }

    @Override
    public Collection<Dsp> getAll() {
        Collection<Dsp> dsps = dspCached.getAll();
        return dsps;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isInfoEnabled()) {
            log.info("dsp = {}", new String(data));
        }
        Dsp dsp = JsonHelper.convert(data, Dsp.class);
        Long id = dsp.getId();
        String key = dsp.getClass().getName() + "$" + id;
        dataSyncProducer.post(key, dsp);
        //此处redis数据在adxcounter中使用，不能直接修改
        updater.hremove(getKeyGenerator(), Objects.toString(id));
        if (!dsp.isForbidden()) {
            updater.hupdate(getKeyGenerator(), Objects.toString(id), dsp);
        }
    }

    private KeyGenerator getKeyGenerator() {
        return () -> KeyBuilder.build("ADX", "DSPS");
    }
}
