package com.bxm.adx.common.buy.dsp;

import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import java.util.Objects;

/**
 * @author allen
 * @since 2019-12-16
 */
@Configuration
public class DspServiceImpl implements DspService {
    private final DspCached dspCached;

    public DspServiceImpl(DspCached dspCached) {
        this.dspCached = dspCached;
    }

    @Override
    public Dsp get(Long id) {
        Dsp d = dspCached.getById(id);
        return d;
    }

    @Override
    public Dsp get(String dspCode) {
        Dsp d = dspCached.getByCode(dspCode);
        return d;
    }
}
