package com.bxm.adx.common.buy.position;

import org.springframework.context.annotation.Configuration;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

/**
 * @author fgf
 * @date 2022/11/29
 **/
@Configuration
public class AdvertPointCached implements AdvertPointChangeHandler {
    /**
     * DSP广告端点集合
     * <pre>
     * |-------------|-----------------------------|
     * |    Key      | Value                       |
     * |-------------|-----------------------------|
     * | {dspId-dspPositionId}  |[adPoint,adPoint,...]|
     * |-------------|-----------------------------|
     * </pre>
     */
    private final ConcurrentHashMap<String, AdvertPoint> advertPointMap = new ConcurrentHashMap<>();

    @Override
    public void doUpdate(AdvertPoint old, AdvertPoint latest) {
        if (isExecuteUpdateAndDoDelete(old, latest)) {
            advertPointMap.put(latest.getUniqueKey(), latest);
        }
    }

    @Override
    public void doDelete(AdvertPoint old) {
        advertPointMap.remove(old.getUniqueKey());
    }


    public AdvertPoint getAdPoint(String dspId, String appId, String dspPositionId) {
        return advertPointMap.get(getMapKey(dspId, appId, dspPositionId));
    }


    private static String getMapKey(String dspId, String appId, String dspPositionId) {
        return dspId + "-" + appId + "-" + dspPositionId;
    }
}
