package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.caching.sync.DataSyncHandler;
import com.bxm.adx.common.sysdict.SysDict;
import com.bxm.adx.common.sysdict.SysDictCaching;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author weixing
 */
@Slf4j
@Configuration
public class SysDictDataSyncHandler implements DataSyncHandler{
    private final SysDictCaching sysDictCaching;

    public SysDictDataSyncHandler(SysDictCaching sysDictCaching) {
        this.sysDictCaching = sysDictCaching;
    }

    @Override
    public Class<?> getClazz() {
        return SysDict.class;
    }

    @Override
    public Object set(String key, Object object) {
        SysDict sysDict = (SysDict) object;
        if (sysDict.isDeleted()) {
            sysDictCaching.del(sysDict.getUniqueKey());
        } else {
            sysDictCaching.set(sysDict.getUniqueKey(), sysDict);
        }
        return object;
    }
}
