package com.bxm.adx.common.log;

import com.bxm.warcar.utils.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author fgf
 * @date 2024/3/4
 **/
public class FileByteLogger implements ByteLogger {

    private final Logger mediaRequestLogger = LoggerFactory.getLogger(FileByteLogger.class.getName() + ".media.request");
    private final Logger bxmRequestLogger = LoggerFactory.getLogger(FileByteLogger.class.getName() + ".bxm.request");

    @Override
    public void add(AdxDataLog adxDataLog) {
        LogSourceEnum source = adxDataLog.getSource();
        String log = JsonHelper.convert(adxDataLog);
        switch (source) {
            case MediaRequest:
                mediaRequestLogger.info(log);
                break;
            case BxmRequest:
                bxmRequestLogger.info(log);
                break;
        }
    }
}
