package com.bxm.adx.common.log.ssplog;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.bxm.adx.common.adapter.AdxContext;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.adapter.BidModelAdapter;
import com.bxm.adx.common.log.datalog.DataLogDao;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author zhangdong
 * @date 2023/2/9
 */
@Component
@Slf4j
public class SspLogRecord {

    private final DataLogDao dataLogDao;

    public SspLogRecord(DataLogDao dataLogDao) {
        this.dataLogDao = dataLogDao;
    }

    public void logRecord(String name, String request, String response) {
        try {
            AdxContext adxContext = AdxContextFactory.get();
            BidRequest bidRequest = adxContext.getBidRequest();
            if (bidRequest == null || CollectionUtils.isEmpty(bidRequest.getImps())) {
                return;
            }
            if (!dataLogDao.existDataLog(bidRequest.getImps().get(0).getTag_id(), null)) {
                return;
            }
            adxContext.setSspLog(true);
            log.debug("name:{},sspRequest:{},sspResponse:{}", name, request, response);
        } catch (Exception e) {
        }
    }

    public void logRecord(String name, String request, BidModelAdapter adapter, BidRequest bidReq, BidResponse bidResponse) {
        try {
            AdxContext adxContext = AdxContextFactory.get();
            BidRequest bidRequest = adxContext.getBidRequest();
            if (bidRequest == null || CollectionUtils.isEmpty(bidRequest.getImps())) {
                return;
            }
            if (!dataLogDao.existDataLog(bidRequest.getImps().get(0).getTag_id(), null)) {
                return;
            }
            adxContext.setSspLog(true);
            String response = null;
            Long dspId = null;
            String dspPosid = null;
            if (Objects.nonNull(bidResponse) && CollUtil.isNotEmpty(bidResponse.getSeat_bid())){
                byte[] mediaResponse = adapter.convert(bidResponse, bidReq);
                response = adapter.convertSspResponse(mediaResponse);
                SeatBid seatBid = CollUtil.getFirst(bidResponse.getSeat_bid());
                if (Objects.nonNull(seatBid) && CollUtil.isNotEmpty(seatBid.getBid())){
                    dspId = seatBid.getDspId();
                    dspPosid = seatBid.getDspPosid();
                }
            }
            if (dspId != null && StrUtil.isNotBlank(dspPosid)){
                log.debug("name:{}, dspId:{}, dspPosid:{}, sspRequest:{}, sspResponse:{}, bxmResponse:{}", name , dspId, dspPosid, request, response, JsonHelper.convert(bidResponse));
            } else {
                log.debug("name:{}, sspRequest:{}, sspResponse:{}, bxmResponse:{}", name, request, response, JsonHelper.convert(bidResponse));
            }
        } catch (Exception e) {
        }
    }
}
