package com.bxm.adx.common.market;

import com.bxm.adx.common.market.exchange.ExchangeResult;
import com.bxm.adx.common.market.exchange.PriorityExchanger;
import com.bxm.adx.common.market.filter.DealFilterFactory;
import com.bxm.adx.common.market.monitor.MonitorWrapper;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import java.util.*;

/**
 * RTB 竞价市场，支持优先级批次竞价。
 *
 * @author allen
 * @since 2019-12-16
 */
@Slf4j
@Primary
@Configuration
public class DefaultMarketImpl implements Market {

    private final PriorityExchanger priorityExchanger;
    private final DealFilterFactory dealFilterFactory;
    private final MonitorWrapper monitorWrapper;

    public DefaultMarketImpl(PriorityExchanger priorityExchanger, DealFilterFactory dealFilterFactory,
                             MonitorWrapper monitorWrapper) {
        this.priorityExchanger = priorityExchanger;
        this.dealFilterFactory = dealFilterFactory;
        this.monitorWrapper = monitorWrapper;
    }

    @Override
    public BidResponse exchange(MarketOrders orders) {
        if (CollectionUtils.isEmpty(orders.getPositions())) {
            if (log.isDebugEnabled()) {
                log.debug("positions is null {} ", orders.getBidRequest().getImps());
            }
            return null;
        }
        List<Deal> deals = null;
        ExchangeResult exchangeResult = priorityExchanger.exchange(orders);
        //过滤前是否有正常deal
        boolean previewStatus = exchangeResult.exchangeSuccess();
        dealFilterFactory.filter(orders, exchangeResult);
        //过滤后是否有正常deal
        if (exchangeResult.exchangeSuccess()) {
            deals = exchangeResult.getDeals();
        } else {
            //区分是因为过滤不参竞还是DSP不参竞
            if (previewStatus) {
                throw new AdxException(AdxErrEnum.ADX_EMPTY_RESPONSE);
            }
            throw new AdxException(AdxErrEnum.DSP_EMPTY_RESPONSE);
        }
        BidResponse bidResponse = DealWrapper.merge(deals);
        return bidResponse;
    }
}
