package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.sell.BidRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * @author fgf
 * @date 2023/1/6
 **/
@Configuration
public class AdxBidRequestBuildFactory implements ApplicationListener<ApplicationReadyEvent> {
    private List<AdxBidRequestBuilder> builderList = new ArrayList<>();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        builderList.addAll(event.getApplicationContext().getBeansOfType(AdxBidRequestBuilder.class).values());
    }

    public BidRequest buildAdxBidRequest(BidRequest bidRequest, RequestBuildAttribute attribute) {
        BidRequest init = initAdxBidRequest(bidRequest);
        builderList.forEach(builder -> builder.rebuildAdxBidRequest(init, attribute));
        return init;
    }

    private BidRequest initAdxBidRequest(BidRequest bidRequest) {
        BidRequest adxBidRequest = new BidRequest();
        BeanUtils.copyProperties(bidRequest, adxBidRequest);
        return adxBidRequest;
    }
}
