package com.bxm.adx.common.openlog.event.internal;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidRequest;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;

/**
 * 流量分配过滤情况埋点事件
 *
 * @author fgf
 * @date 2023/11/13
 **/
public class AdxDispatcherFilter extends EventObject {
    private final BidRequest sspRequest;
    private final Map<Integer, Set<Dispatcher>> trashMap;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param sspRequest
     * @param trashMap
     * @throws IllegalArgumentException if source is null.
     */
    public AdxDispatcherFilter(Object source, BidRequest sspRequest, Map<Integer, Set<Dispatcher>> trashMap) {
        super(source);
        this.sspRequest = sspRequest;
        this.trashMap = trashMap;
    }

    public BidRequest getSspRequest() {
        return sspRequest;
    }

    public Map<Integer, Set<Dispatcher>> getTrashMap() {
        return trashMap;
    }
}
