package com.bxm.adx.common.openlog.event.internal;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.exchange.rebuild.filter.FilterInfo;
import com.bxm.adx.common.sell.BidRequest;

import java.util.EventObject;
import java.util.List;

/**
 * @author fgf
 * @date 2024/6/11
 **/
public class AdxDispatcherPriceConfigFilterEvent extends EventObject {
    private final BidRequest bidRequest;
    private final Dispatcher dispatcher;
    private final BidRequest adxRequest;
    private final Buyer buyer;
    private final List<FilterInfo> filterInfos;

    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param bidRequest
     * @param dispatcher
     * @param adxRequest
     * @param buyer
     * @param filterInfos
     * @throws IllegalArgumentException if source is null.
     */
    public AdxDispatcherPriceConfigFilterEvent(Object source, BidRequest bidRequest, Dispatcher dispatcher, BidRequest adxRequest, Buyer buyer, List<FilterInfo> filterInfos) {
        super(source);
        this.bidRequest = bidRequest;
        this.dispatcher = dispatcher;
        this.adxRequest = adxRequest;
        this.buyer = buyer;
        this.filterInfos = filterInfos;
    }

    public List<FilterInfo> getFilterInfos() {
        return filterInfos;
    }

    public BidRequest getBidRequest() {
        return bidRequest;
    }

    public Dispatcher getDispatcher() {
        return dispatcher;
    }

    public BidRequest getAdxRequest() {
        return adxRequest;
    }

    public Buyer getBuyer() {
        return buyer;
    }
}
