package com.bxm.adx.common.openlog.event.internal;

import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.util.EventObject;

/**
 * @author fgf
 * @date 2024/5/8
 **/
public class DspWinEvent extends EventObject {
    private final BigDecimal win;
    private final MultiValueMap<String, String> originalParams;
    private final boolean success;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param win
     * @param originalParams
     * @param success
     * @throws IllegalArgumentException if source is null.
     */
    public DspWinEvent(Object source, BigDecimal win, MultiValueMap<String, String> originalParams, boolean success) {
        super(source);
        this.win = win;
        this.originalParams = originalParams;
        this.success = success;
    }

    public BigDecimal getWin() {
        return win;
    }

    public MultiValueMap<String, String> getOriginalParams() {
        return originalParams;
    }

    public boolean getSuccess() {
        return success;
    }
}
