package com.bxm.adx.common.rule;

import com.bxm.adx.common.filter.LimitConfig;
import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * @author fgf
 * @date 2023/3/20
 **/
public class LimitRule {
    private final static String SPLIT = ",";
    private final static String GROUP_SPLIT = "-";
    private final Rule rule;
    private final String separatorChars;
    private final String groupSeparatorChars;

    public LimitRule(Rule rule) {
        this(rule, SPLIT, GROUP_SPLIT);
    }

    public LimitRule(Rule rule, String separatorChars, String groupSeparatorChars) {
        this.rule = rule;
        this.separatorChars = separatorChars;
        this.groupSeparatorChars = groupSeparatorChars;
    }

    public Set<LimitConfig> getSet() {
        String val = rule.ruleValue;
        if (StringUtils.isBlank(val)) {
            return Sets.newHashSet();
        }
        String[] array = val.split(separatorChars);
        Set<LimitConfig> configs = Sets.newHashSetWithExpectedSize(array.length);
        for (String s : array) {
            LimitConfig config = convert(s);
            if (Objects.nonNull(config)) {
                configs.add(config);
            }
        }
        return configs;
    }

    private LimitConfig convert(String s) {
        String[] array = s.split(groupSeparatorChars);
        if (array.length < 4) {
            return null;
        }
        try {
            LimitConfig config = LimitConfig.builder()
                    .type(LimitConfig.LimitType.getLimitType(Integer.valueOf(array[0])))
                    .timeWindow(Integer.valueOf(array[1]))
                    .timeUnit(getTimeUnit(Integer.valueOf(array[2])))
                    .limit(Integer.valueOf(array[3]))
                    .build();
            return config;
        } catch (Exception e) {
        }
        return null;
    }

    private TimeUnit getTimeUnit(int timeUnit) {
        switch (timeUnit) {
            case 1:
                return TimeUnit.HOURS;
            case 2:
                return TimeUnit.DAYS;
        }
        throw new IllegalArgumentException("unsupported timeUnit");
    }
}
