package com.bxm.adx.common.sell;

import com.bxm.adx.common.sell.response.SeatBid;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 竞价结果
 *
 * @author allen
 * @since 2019-12-12
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BidResponse {

    /**
     * Bid Common Requset Object的竞价id，必填
     */
    private String id;
    /**
     * 不竞价设置为空，竞价⾄少需要⼀个对象
     */
    private List<SeatBid> seat_bid;
    /**
     * 出价货币:”CNY”
     */
    private String cur;
    /**
     * 保留字段
     */
    private String ext;
    /**
     * Response的唯⼀id，⽤于追踪
     */
    private String track_id;
    /**
     * 未竞价原因
     */
    private Integer nbr;
    /**
     * 屏蔽设备号时常, unix时间戳, 单位秒
     * cool-down-time
     */
    private Long cdt;
}
