package com.bxm.adx.common.sell.bundlereplace;

import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Objects;

/**
 * 包名替换
 * @author weixing
 */
@Slf4j
@Component
@CachePush("BUNDLE_REPLACE")
public class BundleReplaceDaoImpl implements BundleReplaceDao, Pushable {
    private final DataSyncProducer dataSyncProducer;

    public BundleReplaceDaoImpl(DataSyncProducer dataSyncProducer) {
        this.dataSyncProducer = dataSyncProducer;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isInfoEnabled()) {
            log.info("bundle replace data = {}", JsonHelper.convert(data, String.class));
        }

        BundleReplace bundleReplace = JsonHelper.convert(data, BundleReplace.class);
        if (Objects.isNull(bundleReplace) || StringUtils.isBlank(bundleReplace.getPositionId()) || StringUtils.isBlank(bundleReplace.getDspId()) || StringUtils.isBlank(bundleReplace.getDspPosId()) || StringUtils.isBlank(bundleReplace.getBundle()) || StringUtils.isBlank(bundleReplace.getReplaceBundle())) {
            return;
        }
        String key = bundleReplace.getClass().getName() + "$" + bundleReplace.getUniqueKey();
        dataSyncProducer.post(key, bundleReplace);
    }
}
