package com.bxm.adx.common.sell.init;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.User;
import com.bxm.adx.common.sell.settings.MediaInstalledAppMapping;
import com.bxm.adx.common.sell.settings.MediaInstalledAppMappingCaching;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Objects;

/**
 * @author fgf
 * @date 2024/12/24
 **/
@Configuration
public class UserInitializer implements BidRequestInitializer {

    private final MediaInstalledAppMappingCaching mediaInstalledAppMappingCaching;

    public UserInitializer(MediaInstalledAppMappingCaching mediaInstalledAppMappingCaching) {
        this.mediaInstalledAppMappingCaching = mediaInstalledAppMappingCaching;
    }

    @Override
    public void accept(BidRequest request, InitializerParam param) {
        User user = request.getUser();
        if (null == user) {
            return;
        }

        List<String> mappingList = getInstallList(user, param.getPosition());
        if (CollectionUtils.isNotEmpty(mappingList)) {
            user.setMapping_installed_app_list(mappingList);
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }

    /**
     * 匹配映射值
     *
     * @param user
     * @return
     */
    private List<String> getInstallList(User user, Position position) {
        List<String> installList = Objects.isNull(user) ? null : user.getInstalled_app_list();
        if (CollectionUtils.isEmpty(installList)) {
            return null;
        }
        List<String> mappingList = Lists.newArrayListWithCapacity(installList.size());
        Long developerId = position.getDeveloperId();
        if (null != developerId) {
            installList.forEach(s -> {
                        MediaInstalledAppMapping mapping = mediaInstalledAppMappingCaching.get(developerId + ":" + s);
                        if (null != mapping) {
                            mappingList.add(mapping.getInstalledPackageName());
                        }
                    }
            );
        }
        return mappingList;
    }
}
