package com.bxm.adx.common.sell.response;

import com.bxm.adx.common.AdxConstants;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class Native implements Serializable {
    /**
     * 原⽣⼴告元素列表
     */
    private List<Asset> assets;

    /**
     * 素材模版扩展字段
     */
    private String template;

    public String findTitle() {
        return assets.stream().filter(x -> AdxConstants.AssetType.TITLE.getType().equals(x
                .getType()) && x.getText() != null).map(Asset::getText).map(Text::getText).findFirst().orElse(null);
    }

    public String findDesc() {
        return assets.stream().filter(x -> AdxConstants.AssetType.CONTENT.getType().equals(x
                .getType()) && x.getText() != null).map(Asset::getText).map(Text::getText).findFirst().orElse(null);
    }

    public Image findIcon() {
        return assets.stream().filter(x -> AdxConstants.AssetType.ICON.getType().equals(x
                .getType()) && x.getImg() != null).map(Asset::getImg).findFirst().orElse(null);
    }

    public Video findVideo() {
        return assets.stream().filter(x -> x.getVideo() != null).map(Asset::getVideo).findFirst().orElse(null);
    }

    public List<Image> findImage() {
        return assets.stream().filter(x -> AdxConstants.AssetType.LARGE_IMG.getType().equals(x
                .getType()) && x.getImg() != null).map(Asset::getImg).collect(Collectors.toList());
    }

}
