package com.bxm.adx.common.sell.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class Video implements Serializable {
    /**
     * 视频的url
     */
    private String url;
    /**
     * video元素的宽度，单位为像素。
     */
    private Integer w;
    /**
     * video元素的⻓度，单位为像素。
     */
    private Integer h;
    /**
     * 视频类型，1、原⽣视频 2、激励视频
     */
    private Integer video_type;
    /**
     * 视频⻓度。以毫秒为单位
     */
    private Integer duration;
    /**
     * 视频⽂件的封⾯图
     */
    private String cover_url;
    /**
     * 视频格式
     */
    private List<String> mime_types;
    /**
     * 是否允许跳过视频。1：允许 2：不允许
     */
    private Integer skin;
    /**
     * 最⼩播放时⻓，以毫秒为单位，当且仅当skip=1时必填
     */
    private Integer skin_min;
    /**
     * 视频传递形式，0：不限 1：实时 2：预加载
     */
    private String delivery;
    /**
     * 视频的最⼤⼤⼩，以KB为单位
     */
    private Integer max_length;
    /**
     * 缓存视频⼴告多⻓⻓时间内有效，以毫秒为单位
     */
    private Long preload_time;
    /**
     * 视频播放完成之后需要展示的endcard的url
     */
    private String end_card_url;
    /**
     * 激励视频监测地址
     */
    private VideoMonitor v_monitor;
    private Integer direction;
    /**
     * 结束页的HTML源文件内容
     */
    private String end_html;
    /**
     * 结束页返回拦截图
     */
    private String intercept_url;
    /**
     * 视频底部banner
     */
    private String banner_url;
}
