package com.bxm.adx.common;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * @author fgf
 * @date 2025/2/26
 **/
@Data
@ConfigurationProperties(prefix = "algorithm")
public class AlgorithmProperties {
    private List<ModelInfo> modelList;

    @Data
    public static class ModelInfo {
        // 算法模型id
        private String id;
        // 算法模型文件存放路径
        private String path;
        // 起效的算法模型版本
        private String enableVersion;
    }
}
