package com.bxm.adx.common.adapter;

import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginConfigAware;

import java.math.BigDecimal;

/**
 * @author fgf
 * @date 2023/5/15
 **/
public abstract class AbstractPluginBuyModelAdapter implements BuyModelAdapter, PluginConfigAware {
    private PluginConfig pluginConfig;

    @Override
    public void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    public PluginConfig getPluginConfig() {
        return pluginConfig;
    }

    /**
     * 价格加密
     * @param price
     * @return
     */
    public abstract String encrypt(String price, String key);

    /**
     * dsp价格精度控制
     * @param price
     * @return
     */
    public abstract BigDecimal priceScale(BigDecimal price);
}
