package com.bxm.adx.common.algorithm;

import org.tensorflow.SavedModelBundle;

import java.util.Map;

/**
 * @author fgf
 * @date 2025/2/28
 **/
public abstract class AbstractModelService implements ModelService {

    protected ModelGenerateBus modelGenerateBus;

    public AbstractModelService(ModelGenerateBus modelGenerateBus) {
        this.modelGenerateBus = modelGenerateBus;
    }

    protected Map<String, Long> getOneHot() {
        return modelGenerateBus.getOneHotMap(modelId());
    }

    protected SavedModelBundle getSavedModel() {
        return modelGenerateBus.getSavedModelBundleMap(modelId());
    }

    protected String getVersion() {
        return modelGenerateBus.getModelVersionMap(modelId());
    }
}
