package com.bxm.adx.common.algorithm.service;

import com.bxm.adx.common.algorithm.*;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.warcar.ip.IP;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;
import org.tensorflow.Tensor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author fgf
 * @date 2025/2/28
 **/
@Slf4j
@Service
public class BiddingRateModelService extends AbstractModelService {

    /**
     "dsp_id": "f1001", "dsp_app_id": "f1002", "dsp_tag_id": "f1003", "ssp_tag_id": "f1004",
     "media_id": "f1005", "config_id": "f1006", "adx_app_id": "f1007", "app_name": "f1008",
     "app_version": "f1009", "app_bundle": "f1010", "brand": "f1011", "os": "f1012",
     "osv": "f1013", "country": "f1014", "province": "f1015", "city": "f1016", "county": "f1017",
     "create_id": "f1018", "app_package": "f1019", "request_size": "f1020", "dsp_win_price": "f1021",
     "strategy_id": "f1022", "task_id": "f1023", "strategy_price_id": "f1024",
     "device_experiment_id": "f1024", "ad_block_id": "f1026", "dsp_price": "f1027"
     */
    public static float[] eigenvalue = new float[]{
            1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
            1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
            1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
            1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f
    };

    public BiddingRateModelService(ModelGenerateBus modelGenerateBus) {
        super(modelGenerateBus);
    }

    @Override
    public String call(AlgorithmAttribute algorithmAttribute) {
        Map<String, Long> oneHot = getOneHot();
        SavedModelBundle savedModelBundle = getSavedModel();
        if (Objects.isNull(oneHot) || Objects.isNull(savedModelBundle)) {
            if (log.isDebugEnabled()) {
                log.debug("Model load error");
            }
            return null;
        }
        float[] values = eigenvalue;
        long[] ids = getByOneHotMap(oneHot, algorithmAttribute);
        try (Tensor featIds = Tensor.create(ids);
             Tensor featValues = Tensor.create(values)) {
            Session.Runner runner = savedModelBundle.session().runner();
            runner.feed(ModelService.featIds, featIds);
            runner.feed(ModelService.featVals, featValues);
            Tensor tensor = runner.fetch(ModelService.returnValue).run().get(0);
            float[] r = new float[1];
            tensor.copyTo(r);
            tensor.close();
            return String.valueOf(r[0]);
        } catch (Exception e) {
            log.error("Algo-model err {}", e.getMessage());
        }
        return null;
    }


    @Override
    public String modelId() {
        return AlgorithmModelEnum.BiddingModel.name();
    }

    public static long[] getByOneHotMap(Map<String, Long> oneHot, AlgorithmAttribute algorithmAttribute) {
        long[] longs = new long[eigenvalue.length];
        List<String> keyName = keyNameProcess(algorithmAttribute);
        for (int i = 0; i < longs.length; i++) {
            longs[i] = MapUtils.getLong(oneHot, keyName.get(i), 0L);
        }
        return longs;
    }

    /**
     "dsp_id": "f1001", "dsp_app_id": "f1002", "dsp_tag_id": "f1003", "ssp_tag_id": "f1004",
     "media_id": "f1005", "config_id": "f1006", "adx_app_id": "f1007", "app_name": "f1008",
     "app_version": "f1009", "app_bundle": "f1010", "brand": "f1011", "os": "f1012",
     "osv": "f1013", "country": "f1014", "province": "f1015", "city": "f1016", "county": "f1017",
     "create_id": "f1018", "app_package": "f1019", "request_size": "f1020", "dsp_win_price": "f1021",
     "strategy_id": "f1022", "task_id": "f1023", "strategy_price_id": "f1024",
     "device_experiment_id": "f1024", "ad_block_id": "f1026", "dsp_price": "f1027"
     * @param algorithmAttribute
     * @return
     */
    private static List<String> keyNameProcess(AlgorithmAttribute algorithmAttribute) {
        Buyer buyer = algorithmAttribute.getBuyer();
        Dispatcher dispatcher = algorithmAttribute.getDispatcher();
        BidRequest sspRequest = algorithmAttribute.getSspRequest();
        BidRequest adxRequest = algorithmAttribute.getAdxRequest();
        BidResponse response = algorithmAttribute.getAdxResponse();
        IP ip = algorithmAttribute.getIp();
        List<String> keyList = new ArrayList<>(eigenvalue.length);
        keyList.add("f1001_" + buyer.getDsp().getId());
        keyList.add("f1002_" + (Objects.nonNull(adxRequest.getApp()) ? adxRequest.getApp().getId() : null));
        keyList.add("f1003_" + adxRequest.getImps().iterator().next().getTag_id());
        keyList.add("f1004_" + sspRequest.getImps().iterator().next().getTag_id());
        keyList.add("f1005_" + sspRequest.getMediaId());
        keyList.add("f1006_" + dispatcher.getConfigId());
        keyList.add("f1007_" + (Objects.nonNull(sspRequest.getApp()) ? sspRequest.getApp().getId() : null));
        keyList.add("f1008_" + (Objects.nonNull(sspRequest.getApp()) ? sspRequest.getApp().getName() : null));
        keyList.add("f1009_" + (Objects.nonNull(sspRequest.getApp()) ? sspRequest.getApp().getVer() : null));
        keyList.add("f1010_" + (Objects.nonNull(sspRequest.getApp()) ? sspRequest.getApp().getBundle() : null));
        keyList.add("f1011_" + (Objects.nonNull(sspRequest.getDevice()) ? sspRequest.getDevice().getBrand() : null));
        keyList.add("f1012_" + (Objects.nonNull(sspRequest.getDevice()) ? sspRequest.getDevice().getOs() : null));
        keyList.add("f1013_" + (Objects.nonNull(sspRequest.getDevice()) ? sspRequest.getDevice().getOsv() : null));
        keyList.add("f1014_" + (Objects.nonNull(sspRequest.getDevice()) ? sspRequest.getDevice().getCountry() : null));
        keyList.add("f1015_" + (Objects.nonNull(ip) ? ip.getProvince() : null));
        keyList.add("f1016_" + (Objects.nonNull(ip) ? ip.getCity() : null));
        keyList.add("f1017_" + (Objects.nonNull(ip) ? ip.getCounty() : null));
        keyList.add("f1018_" + response.getSeat_bid().iterator().next().getBid().iterator().next().getCreate_id());
        keyList.add("f1019_" + (Objects.nonNull(sspRequest.getApp()) ? sspRequest.getApp().getBundle() : null));
        keyList.add("f1020_" + getRequestSize(sspRequest));
        keyList.add("f1021_" + response.getSeat_bid().iterator().next().getBid().iterator().next().getDspWinPrice());
        keyList.add("f1022_" + dispatcher.getStrategyId());
        keyList.add("f1023_" + response.getSeat_bid().iterator().next().getBid().iterator().next().getTask_id());
        keyList.add("f1024_" + response.getSeat_bid().iterator().next().getBid().iterator().next().getDpc_id());
        keyList.add("f1025_" + sspRequest.getExpId());
        keyList.add("f1026_" + sspRequest.getImps().iterator().next().getExt_tag_id());
        keyList.add("f1027_" + response.getSeat_bid().iterator().next().getBid().iterator().next().getDsp_price());
        return keyList;
    }

    private static String getRequestSize(BidRequest sspRequest) {
        if (sspRequest == null) {
            return null;
        }
        String size = "";
        Impression impression = sspRequest.getImps().get(0);
        if (impression.getW() != null) {
            size = size + impression.getW();
        }
        if (impression.getH() != null) {
            size = size + "*" + impression.getH();
        }
        if (StringUtils.isEmpty(size)) {
            return null;
        }
        return size;
    }
}
