package com.bxm.adx.common.algorithm.test;

import com.bxm.adx.common.algorithm.AlgorithmAttribute;
import com.bxm.adx.common.algorithm.AlgorithmModelEnum;
import com.bxm.adx.common.algorithm.ModelGenerateBus;
import com.bxm.adx.common.algorithm.service.BiddingRateModelService;
import com.bxm.adx.common.ip.IpService;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.openlog.event.internal.AdxAlgorithmEvent;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.ip.IP;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author fgf
 * @date 2025/3/3
 **/
@Slf4j
@Service
public class BiddingRateTestService {

    private final BiddingRateModelService biddingRateModelService;
    private final IpService ipService;
    private final EventPark eventPark;
    private final ModelGenerateBus modelGenerateBus;
    public BiddingRateTestService(BiddingRateModelService biddingRateModelService, IpService ipService, EventPark eventPark, ModelGenerateBus modelGenerateBus) {
        this.biddingRateModelService = biddingRateModelService;
        this.ipService = ipService;
        this.eventPark = eventPark;
        this.modelGenerateBus = modelGenerateBus;
    }

    @Async("biddingRateExecutor")
    public void test(Deal deal) {
        String version = abtest();
        AlgorithmAttribute attribute = AlgorithmAttribute.builder()
                .adxRequest(deal.getAdxRequest())
                .sspRequest(deal.getBidRequest())
                .buyer(deal.getBuyer())
                .dispatcher(deal.getDispatcher())
                .adxResponse(deal.getBidResponse())
                .version(version)
                .ip(ipAnalyze(deal.getBidRequest()))
                .build();
        String result = biddingRateModelService.call(attribute);
        eventPark.post(new AdxAlgorithmEvent(this, deal.getBidRequest(), deal.getBidResponse(), AlgorithmModelEnum.BiddingModel.name(),
                version, result));
    }

    private String abtest() {
        return modelGenerateBus.getModelVersionMap(AlgorithmModelEnum.BiddingModel.name());
    }

    private IP ipAnalyze(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        String ip = Objects.nonNull(device) ? device.getIp() : null;
        return ipService.analyze(ip);
    }
}
