package com.bxm.adx.common.algorithm.test;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.exchange.ExchangeResult;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.warcar.integration.pair.Pair;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * @author fgf
 * @date 2025/3/3
 **/
@Slf4j
@Aspect
@Component
public class DealFilterFactoryAspect {
    private final BiddingRateTestService biddingRateTestService;
    private final Pair pair;
    private final static String ALGO_CONTROL_KEY = "algo:control:key";

    public DealFilterFactoryAspect(BiddingRateTestService biddingRateTestService, Pair pair) {
        this.biddingRateTestService = biddingRateTestService;
        this.pair = pair;
    }

    @Pointcut("this(com.bxm.adx.common.market.filter.DealFilterFactory) && execution(* filter(..))")
    public void pointcut() {
    }

    @Around("pointcut()")
    public void around(ProceedingJoinPoint joinPoint) throws Throwable {
        // 执行目标方法
        joinPoint.proceed();

        // 在目标方法执行后的逻辑
        try {
            MarketOrders marketOrders = (MarketOrders) joinPoint.getArgs()[0];
            BidRequest request = marketOrders.getBidRequest();
            // 只处理CPM竞价
            if (AdxConstants.BidModel.SUPPORT_CPM != request.getBid_model()) {
                return;
            }
            ExchangeResult result = (ExchangeResult) joinPoint.getArgs()[1];
            if (!result.exchangeSuccess()) {
                return;
            }
            Deal deal = result.getDeals().iterator().next();
            if (!control(deal)) {
                return;
            }
            biddingRateTestService.test(deal);
        } catch (Exception e) {
            log.error("DealFilterFactoryAspect error", e);
            return;
        }
    }

    /**
     * 通过全局配置控制是否执行测试
     * @param deal
     * @return
     */
    private boolean control(Deal deal) {
        Dispatcher dispatcher = deal.getDispatcher();
        String positionId = dispatcher.getPositionId();
        Long dspId = dispatcher.getDspId();
        String dspTagId = dispatcher.getDspPosid();
        String dpcId = deal.getBidResponse().getSeat_bid().iterator().next().getBid().iterator().next().getDpc_id();
        String key = positionId + "_" + dspId + "_" + dspTagId + "_" + dpcId;
        Set<String> openSet = pair.get(ALGO_CONTROL_KEY).ofHashSet();
        if (!CollectionUtils.isEmpty(openSet) && openSet.contains(key)) {
            return true;
        }
        return false;
    }
}
