package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.utils.ServerUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * @author fgf
 * @date 2024/9/5
 **/
@Slf4j
@Component
public class GlobalServerConfig {
    /**
     * 数据指定采集的服务器ip，其他服务器不输出日志
     */
    public final static List<String> IP_LIST = Lists.newArrayList("172.21.3.54", "172.21.3.55", "172.21.3.64","172.21.3.57","172.21.3.58");
    /**
     * 本机内网ip
     */
    private String localIpAddress;

    @PostConstruct
    public void init() {
        this.localIpAddress = ServerUtils.getLocalIpAddress();
        log.info("Server IP Address: " + localIpAddress);
    }

    public String getLocalIpAddress() {
        return localIpAddress;
    }

    public boolean hit() {
        //指定ip输出
        return IP_LIST.contains(getLocalIpAddress());
    }
}