package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.algorithm.ModelService;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.market.exchange.Exchanger;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.micrometer.aspect.*;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

import java.util.Collection;

/**
 * @author fgf
 * @date 2023/3/7
 **/
public class MicroMeterAutoConfiguration {
    @Bean
    public ModelServiceMicroMeter modelServiceMicroMeter(ApplicationContext applicationContext) {
        Collection<ModelService> modelServices = applicationContext.getBeansOfType(ModelService.class).values();
        return new ModelServiceMicroMeter(modelServices);
    }

    @Bean
    public ModelServiceMicroMeterAspect modelServiceMicroMeterAspect(ModelServiceMicroMeter modelServiceMicroMeter) {
        return new ModelServiceMicroMeterAspect(modelServiceMicroMeter);
    }

    @Bean
    public DealFilterMicroMeter dealFilterMicroMeter(ApplicationContext applicationContext) {
        Collection<Filter> filters = applicationContext.getBeansOfType(Filter.class).values();
        return new DealFilterMicroMeter(filters);
    }
    @Bean
    public DealFilterMicroMeterAspect dealFilterMicroMeterAspect(DealFilterMicroMeter dealFilterMicroMeter) {
        return new DealFilterMicroMeterAspect(dealFilterMicroMeter);
    }

    @Bean
    public MarketOrderFilterMicroMeter marketOrderFilterMicroMeter(ApplicationContext applicationContext) {
        Collection<com.bxm.adx.common.filter.Filter> filters = applicationContext.getBeansOfType(com.bxm.adx.common.filter.Filter.class).values();
        return new MarketOrderFilterMicroMeter(filters);
    }
    @Bean
    public MarketOrderFilterMicroMeterAspect marketOrderFilterMicroMeterAspect(MarketOrderFilterMicroMeter marketOrderFilterMicroMeter) {
        return new MarketOrderFilterMicroMeterAspect(marketOrderFilterMicroMeter);
    }

    @Bean
    public ExchangeMicroMeter exchangeMicroMeter(ApplicationContext applicationContext) {
        Collection<Exchanger> exchangers = applicationContext.getBeansOfType(Exchanger.class).values();
        return new ExchangeMicroMeter(exchangers);
    }

    @Bean
    public ExchangeMicroMeterAspect exchangeMicroMeterAspect(ExchangeMicroMeter exchangeMicroMeter) {
        return new ExchangeMicroMeterAspect(exchangeMicroMeter);
    }

    @Bean
    public DispatcherFilterMicroMeter dispatcherFilterMicroMeter(ApplicationContext applicationContext) {
        Collection<DispatcherFilter> dispatcherFilters = applicationContext.getBeansOfType(DispatcherFilter.class).values();
        return new DispatcherFilterMicroMeter(dispatcherFilters);
    }

    @Bean
    public DispatcherFilterMicroMeterAspect dispatcherFilterMicroMeterAspect(DispatcherFilterMicroMeter dispatcherFilterMicroMeter) {
        return new DispatcherFilterMicroMeterAspect(dispatcherFilterMicroMeter);
    }

}
