package com.bxm.adx.common.autoconfigure;

import com.bxm.openlog.extension.client.HttpClientOpenLogClient;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.extension.client.ws.WsOpenLogClientProperties;
import com.bxm.warcar.utils.NamedThreadFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author fgf
 * @date 2022-06-01
 * @since 1.0
 */
@ConditionalOnProperty(value = WsOpenLogClientProperties.PROPERTY_ENABLE, havingValue = "false")
public class OpenLogAutoConfiguration {

    @Bean
    public OpenLogClient openLogClient() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(100, 100, 0, TimeUnit.SECONDS,
                new LinkedBlockingQueue<>(10000), new NamedThreadFactory("openlog-client"));
        return HttpClientOpenLogClient.builder().setExecutor(executor).build();
    }
}
