package com.bxm.adx.common.buy.dispatcher;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.AdxConstants;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author fgf
 * @date 2023/1/9
 **/
@Slf4j
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DispatcherPriceConfig implements Serializable {

    /**
     * 过滤模式0不限1白名单2黑名单
     */
    public static final int FILTER_MODEL_UNLIMITED = 0;
    public static final int FILTER_MODEL_WHITE = 1;
    public static final int FILTER_MODEL_BLACK = 2;
    public static final int ADV_WIN_PRICE_TYPE_DISCOUNT = 0;
    public static final int ADV_WIN_PRICE_TYPE_MEDIA = 1;
    public static final int STRATEGY_NONE = 0;
    /**
     * 策略1:利润率优选
     */
    public static final int STRATEGY_PMOPT = 1;
    private static final long serialVersionUID = 1850751998700070857L;

    private Long id;

    /**
     * dsp配置id
     */
    private Long positionDspPosId;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 开始时段
     */
    private Integer startTime;

    /**
     * 结束时段
     */
    private Integer endTime;

    /**
     * 出价系数
     */
    private BigDecimal biddingCoefficient;

    /**
     * 利润率
     * profitMargin%
     */
    private BigDecimal profitMargin;

    /**
     * 广告主出价折扣分割线
     * 单位元
     */
    private BigDecimal priceSplit;

    /**
     * 0-price_split时的折扣
     */
    private BigDecimal ltPriceDiscountFactor;

    /**
     * price_split以上时的折扣
     */
    private BigDecimal gtPriceDiscountFactor;

    /**
     * 分时段固价出价CPM
     */
    private BigDecimal dspCpmPrice;

    /**
     * 媒体出价类型0：固价 1：不设置 2：固价+打折，3按广告主出价
     */
    private Integer mediaOfferType;

    /**
     * 媒体出价类型为固价时的出价金额
     */
    private BigDecimal mediaOfferPrice;

    /**
     * cpc出价上限
     */
    private BigDecimal cpcUpperLimit;

    /**
     * 广告主出价类型1不设置（按dsp出价成交），2固价，3打折，4：按媒体成交价
     */
    private Integer advertiserOfferType;

    /**
     * 广告主赢价计算方式 0：打折后dsp出价，1：按媒体成交价
     */
    private Integer advertiserWinPriceType;

    /**
     * 广告主按媒体成交价计算时的利润率
     */
    private BigDecimal advertiserProfitMargin;

    /**
     * 广告主出价类型为固价时的出价金额
     */
    private BigDecimal advertiserOfferPrice;

    private Long priceModeId;

    private String priceModeName;

    /**
     * 过滤模式0：不限，1：白名单，2：黑名单
     */
    private Integer filterMode;

    private String taskId;

    private List<String> taskIds;

    /**
     * app包名过滤模式0:不限，1:白名单，2:黑名单
     */
    private Integer appPkgFilterMode;

    /**
     * 需定向的app包名
     */
    private String appPackages;

    private List<String> appPackageList;

    /**
     * 曝光控制模式0:不限，1:设置曝光上限
     */
    private Integer exposureFilterMode;

    /**
     * 需控制的曝光数值
     */
    private Integer exposureValue;

    /**
     * 需过滤的dsp出价最低数值
     */
    private BigDecimal filterDspPrice;

    /**
     * 开关0：开，1：关
     */
    private Integer opened;

    /**
     * 媒体价格单位cpm-1/cpc-2/ocpm-3
     */
    private Integer mediaCostType;

    /**
     * 转化目标 12-首次唤起
     */
    private Integer conversionTarget;

    /**
     * 人群包定向,多个逗号分隔 示例："1,2&3" 1,2是白，3是黑
     */
    private Rule crowdPackageOrientation;

    /**
     * 智能策略 0无/1利润率优选
     */
    private Integer strategy;

    /**
     * 利润率下限
     */
    private BigDecimal profitMarginLower;

    /**
     * 利润率上限
     */
    private BigDecimal profitMarginUpper;

    /**
     * 利润率分组
     */
    private Map<Integer, BigDecimal> profitMarginGroupMap;

    /**
     * 投放域名过滤模式0:不限，1:白名单，2:黑名单
     */
    private Integer domainFilterMode;

    /**
     * 投放域名定向
     */
    private String domains;

    /**
     * 投放媒体广告位过滤模式0:不限，1:白名单，2:黑名单
     */
    private Integer mediaTagIdFilterMode;

    /**
     * 媒体广告位定向
     */
    private String mediaTagIdDirect;

    /**
     * 设置利润率分组
     */
    public Map<Integer, BigDecimal> getProfitMarginGroupMap() {
        try {
            //当媒体出价为不设置并且开启利润率优选策略
            if (Objects.isNull(mediaOfferType) || AdxConstants.DispatcherAvgType.NONE != mediaCostType) {
                return null;
            }
            if (Objects.isNull(strategy) || STRATEGY_PMOPT != strategy) {
                return null;
            }
            if (Objects.nonNull(profitMarginLower) && Objects.nonNull(profitMarginUpper) && Objects.nonNull(profitMargin)) {
                BigDecimal interval = profitMarginUpper.subtract(profitMarginLower).divide(BigDecimal.valueOf(3), 1, RoundingMode.HALF_UP);
                Map<Integer, BigDecimal> group = Maps.newHashMapWithExpectedSize(5);
                group.put(0, profitMargin.setScale(2, RoundingMode.HALF_UP));
                group.put(1, profitMarginLower.setScale(2, RoundingMode.HALF_UP));
                group.put(2, profitMarginLower.add(interval).setScale(2, RoundingMode.HALF_UP));
                group.put(3, profitMarginLower.add(interval.multiply(BigDecimal.valueOf(2))).setScale(2, RoundingMode.HALF_UP));
                group.put(4, profitMarginUpper.setScale(2, RoundingMode.HALF_UP));
                return group;
            }
        } catch (Exception e) {
            log.error("setProfitMarginGroupMap error", e);
        }
        return null;
    }

    public List<String> getTaskIds() {
        if (StringUtils.isNotBlank(taskId)) {
            return Arrays.asList(taskId.split(","));
        }
        return null;
    }

    public List<String> getAppPackageList() {
        if (StringUtils.isNotBlank(appPackages)) {
            return Arrays.asList(appPackages.split(","));
        }
        return null;
    }

    public List<String> getDomainList() {
        if (StringUtils.isNotBlank(domains)) {
            return Lists.newArrayList(domains.split(","));
        }
        return null;
    }

    public List<String> getMediaTagIdList() {
        if (StringUtils.isNotBlank(mediaTagIdDirect)) {
            return Lists.newArrayList(mediaTagIdDirect.split(","));
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DispatcherPriceConfig that = (DispatcherPriceConfig) o;
        return getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
