package com.bxm.adx.common.buy.dispatcher.abtest;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.caching.Id;
import lombok.Data;

import java.util.List;

/**
 * @author fgf
 * @date 2022/12/7
 **/
@Data
public class DispatcherConfig implements Id {

    public static final int startInclusive = 0;

    public static final int endExclusive = 100;

    /**
     * ID
     */
    private Long id;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 名称
     */
    private String name;

    /**
     * 用户分桶-开始
     */
    private Integer start;

    /**
     * 用户分桶-结束
     */
    private Integer end;

    /**
     * 配置下的DSP列表
     */
    private List<Dispatcher> dispatcherDspCaches;

    @Override
    public String getId() {
        return String.valueOf(id);
    }
}
