package com.bxm.adx.common.buy.dispatcher.control;

import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author fgf
 * @date 2023/11/10
 **/
@CachePush("FLOW_CONTROL")
@Component
@Slf4j
public class AlgoFlowControlDaoImpl implements Pushable, AlgoFlowControlDao {
    private final DataSyncProducer dataSyncProducer;

    public AlgoFlowControlDaoImpl(DataSyncProducer dataSyncProducer) {
        this.dataSyncProducer = dataSyncProducer;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isDebugEnabled()) {
            log.debug("Algo flow control = {}", new String(data));
        }
        AlgoFlowControl algoFlowControl = JsonHelper.convert(data, AlgoFlowControl.class);
        String key = algoFlowControl.getClass().getName() + "$" + algoFlowControl.getUniqueKey();

        dataSyncProducer.post(key, algoFlowControl);
    }
}
