package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.rule.WhiteBlackSetRule;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Impression;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author fgf
 * @date 2025/5/23
 **/
@Slf4j
@Configuration
public class MediaTagIdFilter implements DispatcherFilter<Dispatcher> {
    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        BidRequest request = context.getRequest();
        Impression impression = request.getImps().get(0);
        String extTagId = impression.getExt_tag_id();
        Collection<Dispatcher> dispatchers = context.getValues();
        Set<Dispatcher> removes = dispatchers.stream().filter(
                dispatcher -> limitedByMediaTagId(dispatcher, extTagId)
        ).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    @Override
    public int getOrder() {
        return 1;
    }

    private boolean limitedByMediaTagId(Dispatcher dispatcher, String tagId) {
        Rule rule = dispatcher.getMediaTagIdDirect();
        if (Objects.isNull(rule)) {
            return false;
        }
        WhiteBlackSetRule setRule = new WhiteBlackSetRule(rule);
        Set<String> set = setRule.getSet();
        if (setRule.isWhite()) {
            if (StringUtils.isEmpty(tagId)) {
                if (log.isDebugEnabled()) {
                    log.debug("rm dispatcher {} by : {}", dispatcher.getId(), "mediaTagId-empty");
                }
                return true;
            } else {
                if (CollectionUtils.isNotEmpty(set) && set.contains(tagId)) {
                    return false;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("rm dispatcher {} by : {}", dispatcher.getId(), "mediaTagId-white-empty");
                    }
                    return true;
                }
            }
        } else {
            if (StringUtils.isEmpty(tagId)) {
                return false;
            } else {
                if (CollectionUtils.isNotEmpty(set) && set.contains(tagId)) {
                    if (log.isDebugEnabled()) {
                        log.debug("rm dispatcher {} by : {}", dispatcher.getId(), "mediaTagId-black");
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }
}
