package com.bxm.adx.common.buy.dispatcher.filter;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointCached;
import com.bxm.adx.common.caching.Id;
import com.bxm.warcar.xcache.Fetcher;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author fgf
 * @date 2025/3/10
 **/
@Slf4j
@Configuration
public class QpsLimitFilter implements DispatcherFilter<Dispatcher> {

    private final AdvertPointCached advertPointCached;
    private final Fetcher fetcher;

    public QpsLimitFilter(AdvertPointCached advertPointCached, Fetcher fetcher) {
        this.advertPointCached = advertPointCached;
        this.fetcher = fetcher;
    }

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        Set<Dispatcher> removes = context.getValues().stream().filter(dispatcher -> {
            return isQpsLimit(dispatcher);
        }).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    private boolean isQpsLimit(Dispatcher dispatcher) {
        AdvertPoint advertPoint = advertPointCached.getAdPoint(dispatcher.getDspId().toString(), dispatcher.getDspAppid(), dispatcher.getDspPosid());
        if (advertPoint == null) {
            return false;
        }
//        Long qpsLimit = advertPoint.getQpsLimit();
//        if (qpsLimit == null || qpsLimit <= 0) {
//            return false;
//        }

        String name = advertPoint.getUniqueKey();
        try (Entry entry = SphU.entry(name)) {
            return false;
        } catch (BlockException e) {
            log.debug("limit by qps {}", dispatcher.getDspPosid());
            return true;
        }
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}
