package com.bxm.adx.common.buy.dispatcher.reorder;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import java.util.Set;

/**
 * @author fgf
 * @date 2023/3/15
 **/
@Slf4j
@Configuration
public class DispatcherSdkConcurrencyModelReorder implements DispatcherReorder {
    @Override
    public Collection<Dispatcher> reorder(DispatcherContext<Dispatcher> context) {
        Set<Dispatcher> reorderList = Sets.newHashSet();
        for (Dispatcher dispatcher : context.getValues()) {
            dispatcher.setPriority(1);
            reorderList.add(dispatcher);
        }
        return reorderList;
    }

    @Override
    public DispatcherOrderStrategy orderStrategy() {
        return DispatcherOrderStrategy.sdk_concurrency;
    }
}
