package com.bxm.adx.common.buy.dsp;

import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author fgf
 * @date 2022/12/23
 **/
@Configuration
public class DspCached implements DspChangeHandler{
    /**
     * DSP集合
     * <pre>
     * |-------------|-----------------------------|
     * |    Key      | Value                       |
     * |-------------|-----------------------------|
     * | {dspCode}   |[dsp,dsp,...]                |
     * |-------------|-----------------------------|
     * </pre>
     */
    private final ConcurrentHashMap<String, Dsp> dspCodeMap = new ConcurrentHashMap<>();
    /**
     * DSP集合
     * <pre>
     * |-------------|-----------------------------|
     * |    Key      | Value                       |
     * |-------------|-----------------------------|
     * | {dspId}     |[dsp,dsp,...]                |
     * |-------------|-----------------------------|
     * </pre>
     */
    private final ConcurrentHashMap<Long, Dsp> dspIdMap = new ConcurrentHashMap<>();

    @Override
    public void doUpdate(Dsp old, Dsp latest) {
        if (isExecuteUpdateAndDoDelete(old, latest)) {
            dspIdMap.put(latest.getId(), latest);
            dspCodeMap.put(latest.getDspCode(), latest);
        }
    }

    @Override
    public void doDelete(Dsp old) {
        dspCodeMap.remove(old.getDspCode());
        dspIdMap.remove(old.getId());
    }

    public Collection<Dsp> getAll() {
        return dspIdMap.values();
    }

    public Dsp getById(Long id) {
        return dspIdMap.get(id);
    }

    public Dsp getByCode(String code) {
        return dspCodeMap.get(code);
    }
}
