package com.bxm.adx.common.buy.dsp.domainmapping;

import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author fgf
 * @date 2025/6/6
 **/
@CachePush("DOMAIN_MAPPING")
@Component
@Slf4j
public class AdxDomainMappingConfigDaoImpl implements AdxDomainMappingConfigDao, Pushable {
    private final DataSyncProducer dataSyncProducer;

    public AdxDomainMappingConfigDaoImpl(DataSyncProducer dataSyncProducer) {
        this.dataSyncProducer = dataSyncProducer;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isInfoEnabled()) {
            log.info("domain mapping = {}", new String(data));
        }
        AdxDomainMappingConfig config = JsonHelper.convert(data, AdxDomainMappingConfig.class);
        Long id = config.getId();
        String key = config.getClass().getName() + "$" + id;
        dataSyncProducer.post(key, config);
    }
}
