package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.caching.sync.DataSyncHandler;
import com.bxm.adx.common.sell.bundlereplace.BundleReplace;
import com.bxm.adx.common.sell.bundlereplace.BundleReplaceCaching;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2024/12/24
 **/
@Configuration
public class BundleReplaceDataSyncHandler implements DataSyncHandler {
    private final BundleReplaceCaching bundleReplaceCaching;

    public BundleReplaceDataSyncHandler(BundleReplaceCaching bundleReplaceCaching) {
        this.bundleReplaceCaching = bundleReplaceCaching;
    }

    @Override
    public Class<?> getClazz() {
        return BundleReplace.class;
    }

    @Override
    public Object set(String key, Object object) {
        BundleReplace bundleReplace = (BundleReplace) object;

        if (bundleReplace.isDeleted()) {
            bundleReplaceCaching.del(bundleReplace.getUniqueKey());
        } else {
            bundleReplaceCaching.set(bundleReplace.getUniqueKey(), bundleReplace);
        }

        return object;
    }
}
