package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.caching.sync.DataSyncHandler;
import com.bxm.adx.common.sell.settings.MediaInstalledAppMapping;
import com.bxm.adx.common.sell.settings.MediaInstalledAppMappingCaching;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2024/12/24
 **/
@Configuration
public class MediaInstalledAppMappingDataSyncHandler implements DataSyncHandler {
    private final MediaInstalledAppMappingCaching mediaInstalledAppMappingCaching;

    public MediaInstalledAppMappingDataSyncHandler(MediaInstalledAppMappingCaching mediaInstalledAppMappingCaching) {
        this.mediaInstalledAppMappingCaching = mediaInstalledAppMappingCaching;
    }

    @Override
    public Class<?> getClazz() {
        return MediaInstalledAppMapping.class;
    }

    @Override
    public Object set(String key, Object object) {
        MediaInstalledAppMapping mediaInstalledAppMapping = (MediaInstalledAppMapping) object;

        if (mediaInstalledAppMapping.isDelete()) {
            mediaInstalledAppMappingCaching.del(mediaInstalledAppMapping.getUniqueKey());
        } else {
            mediaInstalledAppMappingCaching.set(mediaInstalledAppMapping.getUniqueKey(), mediaInstalledAppMapping);
        }

        return object;
    }
}
