package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.caching.sync.DataSyncHandler;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionCaching;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2022/12/13
 **/
@Configuration
public class PositionDataSyncHandler implements DataSyncHandler {
    private final PositionCaching positionCaching;

    public PositionDataSyncHandler(PositionCaching positionCaching) {
        this.positionCaching = positionCaching;
    }

    @Override
    public Class<?> getClazz() {
        return Position.class;
    }

    @Override
    public Object set(String key, Object object) {
        Position position = (Position) object;

        if (position.isEnabled()) {
            positionCaching.set(position.getPositionId(), position);
        } else {
            positionCaching.del(position.getPositionId());
        }
        return object;
    }
}
