package com.bxm.adx.common.creative.review;

import com.bxm.mccms.facade.model.pushable.CreativeReviewCacheVO;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author fgf
 * @date 2023/9/5
 **/
@Slf4j
@CachePush("CREATIVE_REVIEW")
public class ReviewCreativeDaoImpl implements ReviewCreativeDao, Pushable {
    private final DataSyncProducer dataSyncProducer;
    private final ReviewCreativeCaching reviewCreativeCaching;

    public ReviewCreativeDaoImpl(DataSyncProducer dataSyncProducer, ReviewCreativeCaching reviewCreativeCaching) {
        this.dataSyncProducer = dataSyncProducer;
        this.reviewCreativeCaching = reviewCreativeCaching;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isInfoEnabled()) {
            log.info("review creative data = {}", JsonHelper.convert(data, String.class));
        }

        CreativeReviewCacheVO creativeReviewCacheVO = JsonHelper.convert(data, CreativeReviewCacheVO.class);
        if (Objects.isNull(creativeReviewCacheVO) || Objects.isNull(creativeReviewCacheVO.getId())) {
            return;
        }
        log.info("reviewCreativePush data : {}",JsonHelper.convert(creativeReviewCacheVO));
        String key = creativeReviewCacheVO.getClass().getName() + "$" + creativeReviewCacheVO.getId();
        dataSyncProducer.post(key, creativeReviewCacheVO);
    }

    @Override
    public List<ReviewCreative> queryCreativeListByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ReviewCreative> creatives = Lists.newArrayListWithCapacity(ids.size());
        for (Long id : ids) {
            if (Objects.isNull(id)) {
                continue;
            }
            ReviewCreative reviewCreative = null;
            reviewCreative = reviewCreativeCaching.get(String.valueOf(id));
            if (Objects.isNull(reviewCreative)) {
                if (log.isWarnEnabled()) {
                    log.warn("review-creative id = {}, not exist", id);
                }
                continue;
            }
            creatives.add(reviewCreative);
        }
        return creatives;
    }
}
