package com.bxm.adx.common.filter;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.Comparator;
import java.util.List;
import java.util.Map;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/20 16:32
 */

@Slf4j
@Component
public class MarketOrdersFilterChain implements ApplicationListener<ApplicationReadyEvent> {

    private List<Filter> list = Lists.newArrayList();

    public void doFilter(FilterRequest request) {
        list.forEach(l -> {
            l.filter(request);
        });
    }

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        final Map<String, Filter> beansOfType = event.getApplicationContext().getBeansOfType(Filter.class);
        if (MapUtils.isNotEmpty(beansOfType)) {
            for (Map.Entry<String, Filter> entry : beansOfType.entrySet()) {
                list.add(entry.getValue());
            }
        }
        list.sort(Comparator.comparingInt(Filter::order));
        for (int i = 0; i < list.size(); i++) {
            log.info("Filter [{}] : {} init . ", i, list.get(i).getClass());
        }
        log.info("All [{}] filter impl init finish .", list.size());
    }
}
