package com.bxm.adx.common.log.ssplog;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.bxm.adx.common.adapter.AdxContext;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.adapter.BidModelAdapter;
import com.bxm.adx.common.log.datalog.DataLogDao;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * @author zhangdong
 * @date 2023/2/9
 */
@Component
@Slf4j
public class SspLogRecord {

    private final DataLogDao dataLogDao;
    private final Pair pair;

    public SspLogRecord(DataLogDao dataLogDao, Pair pair) {
        this.dataLogDao = dataLogDao;
        this.pair = pair;
    }

    public void logRecord(String name, String request, String response) {
        try {
            AdxContext adxContext = AdxContextFactory.get();
            BidRequest bidRequest = adxContext.getBidRequest();
            if (bidRequest == null || CollectionUtils.isEmpty(bidRequest.getImps())) {
                return;
            }
            if (!dataLogDao.existDataLog(bidRequest.getImps().get(0).getTag_id(), null)) {
                return;
            }
            adxContext.setSspLog(true);
            log.debug("name:{},sspRequest:{},sspResponse:{}", name, request, response);
        } catch (Exception e) {
        }
    }

    public void logRecord(String name, String request, BidModelAdapter adapter, BidRequest bidReq, BidResponse bidResponse) {
        logBxmRequest(bidReq, bidResponse);
        try {
            AdxContext adxContext = AdxContextFactory.get();
            BidRequest bidRequest = adxContext.getBidRequest();
            if (bidRequest == null || CollectionUtils.isEmpty(bidRequest.getImps())) {
                return;
            }
            if (!dataLogDao.existDataLog(bidRequest.getImps().get(0).getTag_id(), null)) {
                return;
            }
            adxContext.setSspLog(true);
            String response = null;
            Long dspId = null;
            String dspPosid = null;
            if (Objects.nonNull(bidResponse) && CollUtil.isNotEmpty(bidResponse.getSeat_bid())){
                byte[] mediaResponse = adapter.convert(bidResponse, bidReq);
                response = adapter.convertSspResponse(mediaResponse);
                SeatBid seatBid = CollUtil.getFirst(bidResponse.getSeat_bid());
                if (Objects.nonNull(seatBid) && CollUtil.isNotEmpty(seatBid.getBid())){
                    dspId = seatBid.getDspId();
                    dspPosid = seatBid.getDspPosid();
                }
            }
            if (dspId != null && StrUtil.isNotBlank(dspPosid)){
                log.debug("name:{}, dspId:{}, dspPosid:{}, sspRequest:{}, sspResponse:{}, bxmResponse:{}", name , dspId, dspPosid, request, response, JsonHelper.convert(bidResponse));
            } else {
                log.debug("name:{}, sspRequest:{}, sspResponse:{}, bxmResponse:{}", name, request, response, JsonHelper.convert(bidResponse));
            }
        } catch (Exception e) {
        }
    }

    private static final List<String> IP_WHITE_LIST = Lists.newArrayList("61.130.182.195");
    private static final String KEY = "white_device_ids";

    /**
     * 记录bxm网络请求/指定设备号日志
     * @param request
     * @param response
     */
    private void logBxmRequest(BidRequest request, BidResponse response) {
        try {
            Set<String> deviceIds = pair.get(KEY).ofHashSet();
            if (CollectionUtils.isEmpty(deviceIds)) {
                return;
            }
            if (Objects.nonNull(request)) {
                Device device = request.getDevice();
                if (Objects.nonNull(device)) {
                    String ip = device.getIp();
                    String idfa = device.getIdfa();
                    String idfaMd5 = device.getIdfa_md5();
                    String imei = device.getImei();
                    String imeiMd5 = device.getImei_md5();
                    String oaid = device.getOaid();
                    String oaidMd5 = device.getOaid_md5();
                    boolean ipHit = IP_WHITE_LIST.contains(ip);
                    boolean deviceHit = CollectionUtils.isEmpty(deviceIds) ? false : (deviceIds.contains(idfa) || deviceIds.contains(idfaMd5) || deviceIds.contains(imei) || deviceIds.contains(imeiMd5) || deviceIds.contains(oaid) || deviceIds.contains(oaidMd5));
                    if (ipHit || deviceHit) {
                        log.info("request: {}, response: {}", JsonHelper.convert(request), JsonHelper.convert(response));
                    }
                }
            }
        } catch (Exception e) {
        }
    }
}
