package com.bxm.adx.common.market;

import com.bxm.adx.common.market.monitor.MonitorWrapper;
import com.bxm.adx.common.sell.BidResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

/**
 * @author fgf
 * @date 2023/4/13
 **/
@Aspect
@Component
public class MarketAspect {
    private final MonitorWrapper monitorWrapper;
    public MarketAspect(MonitorWrapper monitorWrapper) {
        this.monitorWrapper = monitorWrapper;
    }

    @Pointcut("this(com.bxm.adx.common.market.DefaultMarketImpl) && execution(* exchange(..))")
    public void pointcut() {}

    @Around("pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        // 执行目标方法
        Object result = joinPoint.proceed();

        // 在目标方法执行后的逻辑
        if (result instanceof BidResponse) {
            monitorWrapper.monitorWrapper((BidResponse) result);
        }

        // 返回目标方法的执行结果
        return result;
    }
}
