package com.bxm.adx.common.market.exchange.rebuild.filter;

import org.springframework.util.ClassUtils;

import java.util.Arrays;

/**
 * @author fgf
 * @date 2024/6/11
 **/
public enum DispatcherPriceConfigFilterEnum {
    Undefined(0),
    LowPriceDispatcherPriceConfigFilter(4),
    MaxExposureDispatcherPriceConfigFilter(3),
    TaskIdDispatcherPriceConfigFilter(1),
    BidPriceTop1DispatcherPriceConfigFilter(5),
    AppPackageDispatcherPriceConfigFilter(2),
    BidModelDispatcherPriceConfigFilter(6),
    DomainDispatcherPriceConfigFilter(7),
    MediaTagIdDispatcherPriceConfigFilter(8),
    ;

    private int type;

    DispatcherPriceConfigFilterEnum(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }

    public static int getTypeByClass(DispatcherPriceConfigFilter filter) {
        return Arrays.stream(DispatcherPriceConfigFilterEnum.values())
                .filter(f -> {
                    String clazzSimpleName = ClassUtils.getUserClass(filter).getSimpleName();
                    return f.name().equals(clazzSimpleName);
                })
                .findFirst().orElse(Undefined).getType();
    }
}
