package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import java.util.List;
import java.util.Objects;

/**
 * 域名定向
 * @author weixing
 */
@Slf4j
@Configuration
public class DomainDispatcherPriceConfigFilter implements DispatcherPriceConfigFilter{
    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        priceConfigs.removeIf(config -> needFilter(config,bid));
    }

    @Override
    public int getOrder() {
        return 60;
    }

    /**
     * 判断是否需要过滤当前价格配置
     */
    public boolean needFilter(DispatcherPriceConfig config, Bid bid) {
        if (Objects.isNull(config.getDomainFilterMode())) {
            return false;
        }
        String deepLinkUrl = bid.getDeep_link_url();
        String universalLink = bid.getUniversal_link();
        String clickThroughUrl = bid.getClick_through_url();
        if(config.getDomainFilterMode() == DispatcherPriceConfig.FILTER_MODEL_WHITE){
            return !isUrlInDomainList(deepLinkUrl, universalLink, clickThroughUrl, config.getDomainList());
        }
        if(config.getDomainFilterMode() == DispatcherPriceConfig.FILTER_MODEL_BLACK){
            return isUrlInDomainList(deepLinkUrl, universalLink, clickThroughUrl, config.getDomainList());
        }
        return false;
    }


    /**
     * 判断URL是否在域名列表中
     */
    private boolean isUrlInDomainList(String deepLinkUrl, String universalLink, String clickThroughUrl, List<String> domainList) {
        if (CollectionUtils.isEmpty(domainList)) {
            return false;
        }
        for (String domain : domainList) {
            if (StringUtils.isNotBlank(deepLinkUrl) && deepLinkUrl.startsWith(domain)) {
                return true;
            }
            if (StringUtils.isNotBlank(universalLink) && universalLink.startsWith(domain)) {
                return true;
            }
            if (StringUtils.isNotBlank(clickThroughUrl) && clickThroughUrl.startsWith(domain)) {
                return true;
            }
        }
        return false;
    }
}
