package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;

/**
 * 媒体广告位出价过滤
 *
 * @author fgf
 * @date 2025-05-23
 */
@Slf4j
@Configuration
public class MediaTagIdDispatcherPriceConfigFilter implements DispatcherPriceConfigFilter {

    @Override
    public int getOrder() {
        return 20;
    }

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        BidRequest request = attribute.getBidRequest();
        Impression impression = request.getImps().get(0);
        String extTagId = impression.getExt_tag_id();
        priceConfigs.removeIf(config -> whetherHitOrNot(config, extTagId));
    }

    /**
     * 根据包名判断是否需要排除当前出价配置
     *
     * @return ture 排除  false 不排除
     */
    private boolean whetherHitOrNot(DispatcherPriceConfig config, String tagId) {
        Integer model = config.getMediaTagIdFilterMode();
        if (model == null) {
            return false;
        }
        //白名单 包名不在配置列表里排除
        if (DispatcherPriceConfig.FILTER_MODEL_WHITE == model) {
            if (CollectionUtils.isEmpty(config.getMediaTagIdList())) {
                return true;
            }
            if (!config.getMediaTagIdList().contains(tagId)) {
                return true;
            }
        }
        //黑名单 包名在配置列表里排除
        if (DispatcherPriceConfig.FILTER_MODEL_BLACK == model) {
            if (CollectionUtils.isEmpty(config.getMediaTagIdList())) {
                return false;
            }
            return config.getMediaTagIdList().contains(tagId);
        }
        return false;
    }
}
