package com.bxm.adx.common.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @author fgf
 * @date 2023/3/7
 **/
@Slf4j
@Configuration
public class ExchangeCallableMeter implements MeterBinder {
    private Timer exchangeCacheTimer;
    private Timer exchangeTimer;
    @Override
    public void bindTo(MeterRegistry registry) {
        exchangeCacheTimer = Timer.builder("call.cache").tag("name", this.getClass().getName()).register(registry);
        exchangeTimer = Timer.builder("call").tag("name", this.getClass().getName()).register(registry);

    }

    public void recordCacheExchange(long start) {
        if (Objects.nonNull(exchangeCacheTimer)) {
            exchangeCacheTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    public void recordExchange(long start) {
        if (Objects.nonNull(exchangeTimer)) {
            exchangeTimer.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
        }
    }

}
